// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Sqlexpr.pas' rev: 10.00

#ifndef SqlexprHPP
#define SqlexprHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Variants.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Db.hpp>	// Pascal unit
#include <Dbcommon.hpp>	// Pascal unit
#include <Dbcommontypes.hpp>	// Pascal unit
#include <Dbxpress.hpp>	// Pascal unit
#include <Sqltimst.hpp>	// Pascal unit
#include <Widestrings.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Sqlexpr
{
//-- type declarations -------------------------------------------------------
typedef int TLocaleCode;

#pragma option push -b-
enum TSQLExceptionType { exceptConnection, exceptCommand, exceptCursor, exceptMetaData, exceptUseLast };
#pragma option pop

struct SPParamDesc;
typedef SPParamDesc *PSPParamDesc;

#pragma pack(push,1)
struct SPParamDesc
{
	
public:
	Word iParamNum;
	WideString szName;
	Db::TParamType iArgType;
	Db::TFieldType iDataType;
	short iUnits1;
	short iUnits2;
	unsigned iLen;
} ;
#pragma pack(pop)

typedef SPParamDesc  SQLSPParamDesc;

class DELPHICLASS TSQLBlobStream;
class DELPHICLASS TCustomSQLDataSet;
class DELPHICLASS TSQLConnection;
#pragma option push -b-
enum TConnectionState { csStateClosed, csStateOpen, csStateConnecting, csStateExecuting, csStateFetching, csStateDisconnecting };
#pragma option pop

class DELPHICLASS TISQLConnection;
class DELPHICLASS TISQLCommand;
class DELPHICLASS TISQLMetaData;
typedef TMetaClass* TFLDDescRef;

class PASCALIMPLEMENTATION TISQLConnection : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	__fastcall virtual TISQLConnection(Dbxpress::_di_ISQLConnection NewConnection) = 0 ;
	virtual Word __fastcall connect(void) = 0 /* overload */;
	virtual Word __fastcall connect(WideChar * ServerName, WideChar * UserName, WideChar * Password) = 0 /* overload */;
	virtual Word __fastcall disconnect(void) = 0 ;
	virtual Word __fastcall getSQLCommand(TISQLCommand* &pComm) = 0 ;
	virtual Word __fastcall getSQLMetaData(TISQLMetaData* &pMetaData) = 0 ;
	virtual Word __fastcall SetOption(Dbxpress::TSQLConnectionOption eConnectOption, int lValue) = 0 ;
	virtual Word __fastcall SetStringOption(Dbxpress::TSQLConnectionOption eConnectOption, const WideString lValue) = 0 ;
	virtual Word __fastcall GetOption(Dbxpress::TSQLConnectionOption eDOption, void * PropValue, short MaxLength, /* out */ short &Length) = 0 ;
	virtual Word __fastcall GetStringOption(Dbxpress::TSQLConnectionOption eDOption, WideString &str) = 0 ;
	virtual Word __fastcall beginTransaction(unsigned TranID) = 0 ;
	virtual Word __fastcall commit(unsigned TranID) = 0 ;
	virtual Word __fastcall rollback(unsigned TranID) = 0 ;
	virtual Word __fastcall getErrorMessage(WideChar * Error) = 0 /* overload */;
	virtual Word __fastcall getErrorMessageLen(/* out */ short &ErrorLen) = 0 ;
	virtual Word __fastcall getErrorMessage(WideString &Error) = 0 /* overload */;
	virtual TMetaClass* __fastcall getFldDescClass(void) = 0 ;
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TISQLConnection(void) { }
	#pragma option pop
	
};


typedef void __fastcall (__closure *TSQLConnectionLoginEvent)(TSQLConnection* Database, Widestrings::TWideStrings* LoginParams);

#pragma option push -b-
enum TTableScope { tsSynonym, tsSysTable, tsTable, tsView };
#pragma option pop

typedef Set<TTableScope, tsSynonym, tsView>  TTableScopes;

#pragma option push -b-
enum TSchemaType { stNoSchema, stTables, stSysTables, stProcedures, stColumns, stProcedureParams, stIndexes, stPackages, stUserNames };
#pragma option pop

#pragma option push -b-
enum EConnectFlag { eConnect, eReconnect, eDisconnect };
#pragma option pop

class PASCALIMPLEMENTATION TSQLConnection : public Db::TCustomConnection 
{
	typedef Db::TCustomConnection inherited;
	
private:
	unsigned FSelectStatements;
	unsigned FPrevSelectStatements;
	unsigned FActiveStatements;
	bool FAutoClone;
	TSQLConnection* FCloneParent;
	TConnectionState FConnectionState;
	AnsiString FConnectionName;
	AnsiString FConnectionRegistryFile;
	AnsiString FDriverName;
	AnsiString FDriverRegistryFile;
	AnsiString FGetDriverFunc;
	int FTransactionCount;
	bool FIsCloned;
	TISQLConnection* FISQLConnection;
	bool FKeepConnection;
	AnsiString FLastError;
	AnsiString FLibraryName;
	bool FLoadParamsOnConnect;
	Classes::TList* FMonitorUsers;
	TSQLConnectionLoginEvent FOnLogin;
	Widestrings::TWideStrings* FParams;
	bool FParamsLoaded;
	unsigned FMaxStmtsPerConn;
	WideString FQuoteChar;
	WideString FDefaultSchemaName;
	int FRefCount;
	unsigned FSQLDllHandle;
	Dbxpress::_di_ISQLDriver FSQLDriver;
	bool FSQLHourGlass;
	TISQLMetaData* FSQLMetaData;
	BOOL FSupportsMultiTrans;
	TTableScopes FTableScope;
	Dbxpress::TSQLCallbackEvent FTraceCallbackEvent;
	int FTraceClientData;
	BOOL FTransactionsSupported;
	AnsiString FVendorLib;
	Dbxpress::TTransIsolationLevel FTransIsoLevel;
	WideString FLoginUsername;
	void __fastcall CheckActive(void);
	void __fastcall CheckInactive(void);
	void __fastcall CheckLoginParams(void);
	void __fastcall ClearConnectionUsers(void);
	void __fastcall ClearMonitors(void);
	void __fastcall FreeSchemaTable(TCustomSQLDataSet* DataSet);
	TSQLConnection* __fastcall GetConnectionForStatement(void);
	AnsiString __fastcall GetConnectionName();
	AnsiString __fastcall GetFDriverRegistryFile();
	int __fastcall GetLocaleCode(void);
	bool __fastcall GetInTransaction(void);
	AnsiString __fastcall GetLibraryName();
	void __fastcall GetLoginParams(Widestrings::TWideStrings* LoginParams);
	WideString __fastcall GetQuoteChar();
	AnsiString __fastcall GetVendorLib();
	void __fastcall Login(Widestrings::TWideStrings* LoginParams);
	TCustomSQLDataSet* __fastcall OpenSchemaTable(TSchemaType eKind, WideString SInfo, WideString SQualifier = L"", WideString SPackage = L"")/* overload */;
	TCustomSQLDataSet* __fastcall OpenSchemaTable(TSchemaType eKind, WideString SInfo, WideString SQualifier = L"", WideString SPackage = L"", WideString SSchemaName = L"")/* overload */;
	void __fastcall RegisterTraceMonitor(System::TObject* Client);
	void __fastcall RegisterTraceCallback(bool Value);
	void __fastcall SetConnectionParams(void);
	void __fastcall SetConnectionName(AnsiString Value);
	void __fastcall SetDriverName(AnsiString Value);
	void __fastcall SetKeepConnection(bool Value);
	void __fastcall SetParams(Widestrings::TWideStrings* Value);
	void __fastcall SetCursor(int CursorType);
	void __fastcall SetLocaleCode(int Value);
	void __fastcall UnregisterTraceMonitor(System::TObject* Client);
	
protected:
	Word __fastcall Check(Word status);
	void __fastcall CheckConnection(EConnectFlag eFlag);
	virtual void __fastcall CheckDisconnect(void);
	virtual void __fastcall ConnectionOptions(void);
	virtual void __fastcall DoConnect(void);
	virtual void __fastcall DoDisconnect(void);
	virtual bool __fastcall GetConnected(void);
	HIDESBASE TCustomSQLDataSet* __fastcall GetDataSet(int Index);
	virtual void __fastcall Loaded(void);
	void __fastcall LoadSQLDll(void);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	void __fastcall OpenSchema(TSchemaType eKind, WideString sInfo, Widestrings::TWideStrings* List)/* overload */;
	void __fastcall OpenSchema(TSchemaType eKind, WideString sInfo, WideString SSchemaName, Widestrings::TWideStrings* List)/* overload */;
	void __fastcall SQLError(Word OpStatus, TSQLExceptionType eType, const TISQLCommand* Command = (TISQLCommand*)(0x0));
	__property TISQLConnection* Connection = {read=FISQLConnection};
	__property AnsiString ConnectionRegistryFile = {read=FConnectionRegistryFile};
	__property Dbxpress::_di_ISQLDriver Driver = {read=FSQLDriver};
	__property AnsiString DriverRegistryFile = {read=GetFDriverRegistryFile};
	__property AnsiString LastError = {read=FLastError, write=FLastError};
	__property WideString QuoteChar = {read=FQuoteChar};
	__property unsigned SQLDllHandle = {read=FSQLDllHandle, write=FSQLDllHandle, nodefault};
	
public:
	__fastcall virtual TSQLConnection(Classes::TComponent* AOwner);
	__fastcall virtual ~TSQLConnection(void);
	TSQLConnection* __fastcall CloneConnection(void);
	void __fastcall CloseDataSets(void);
	void __fastcall Commit(const Dbxpress::TTransactionDesc &TransDesc);
	int __fastcall Execute(const WideString SQL, Db::TParams* Params, void * ResultSet = (void *)(0x0));
	int __fastcall ExecuteDirect(const WideString SQL);
	void __fastcall GetFieldNames(const AnsiString TableName, Classes::TStrings* List)/* overload */;
	void __fastcall GetFieldNames(const AnsiString TableName, AnsiString SchemaName, Classes::TStrings* List)/* overload */;
	void __fastcall GetFieldNames(const WideString TableName, Widestrings::TWideStrings* List)/* overload */;
	void __fastcall GetFieldNames(const WideString TableName, WideString SchemaName, Widestrings::TWideStrings* List)/* overload */;
	void __fastcall GetIndexNames(const AnsiString TableName, Classes::TStrings* List)/* overload */;
	void __fastcall GetIndexNames(const AnsiString TableName, const AnsiString SchemaName, Classes::TStrings* List)/* overload */;
	void __fastcall GetIndexNames(const WideString TableName, Widestrings::TWideStrings* List)/* overload */;
	void __fastcall GetIndexNames(const WideString TableName, const WideString SchemaName, Widestrings::TWideStrings* List)/* overload */;
	void __fastcall GetProcedureNames(Classes::TStrings* List)/* overload */;
	void __fastcall GetProcedureNames(const AnsiString PackageName, Classes::TStrings* List)/* overload */;
	void __fastcall GetProcedureNames(const AnsiString PackageName, const AnsiString SchemaName, Classes::TStrings* List)/* overload */;
	void __fastcall GetProcedureNames(Widestrings::TWideStrings* List)/* overload */;
	void __fastcall GetProcedureNames(const WideString PackageName, Widestrings::TWideStrings* List)/* overload */;
	void __fastcall GetProcedureNames(const WideString PackageName, const WideString SchemaName, Widestrings::TWideStrings* List)/* overload */;
	void __fastcall GetPackageNames(Classes::TStrings* List)/* overload */;
	void __fastcall GetPackageNames(Widestrings::TWideStrings* List)/* overload */;
	void __fastcall GetSchemaNames(Classes::TStrings* List)/* overload */;
	void __fastcall GetSchemaNames(Widestrings::TWideStrings* List)/* overload */;
	WideString __fastcall GetDefaultSchemaName();
	void __fastcall GetProcedureParams(WideString ProcedureName, Classes::TList* List)/* overload */;
	void __fastcall GetProcedureParams(WideString ProcedureName, WideString PackageName, Classes::TList* List)/* overload */;
	void __fastcall GetProcedureParams(WideString ProcedureName, WideString PackageName, WideString SchemaName, Classes::TList* List)/* overload */;
	void __fastcall GetTableNames(Classes::TStrings* List, bool SystemTables = false)/* overload */;
	void __fastcall GetTableNames(Classes::TStrings* List, WideString SchemaName, bool SystemTables = false)/* overload */;
	void __fastcall GetTableNames(Widestrings::TWideStrings* List, bool SystemTables = false)/* overload */;
	void __fastcall GetTableNames(Widestrings::TWideStrings* List, WideString SchemaName, bool SystemTables = false)/* overload */;
	void __fastcall LoadParamsFromIniFile(WideString FFileName = L"");
	void __fastcall Rollback(const Dbxpress::TTransactionDesc &TransDesc);
	void __fastcall SetTraceCallbackEvent(Dbxpress::TSQLCallbackEvent Event, int IClientInfo);
	void __fastcall StartTransaction(const Dbxpress::TTransactionDesc &TransDesc);
	WideString __fastcall GetLoginUsername();
	__property unsigned ActiveStatements = {read=FActiveStatements, nodefault};
	__property bool AutoClone = {read=FAutoClone, write=FAutoClone, default=1};
	__property TConnectionState ConnectionState = {read=FConnectionState, write=FConnectionState, nodefault};
	__property TCustomSQLDataSet* DataSets[int Index] = {read=GetDataSet};
	__property bool InTransaction = {read=GetInTransaction, nodefault};
	__property int LocaleCode = {read=GetLocaleCode, write=SetLocaleCode, default=0};
	__property unsigned MaxStmtsPerConn = {read=FMaxStmtsPerConn, nodefault};
	__property TISQLMetaData* MetaData = {read=FSQLMetaData};
	__property BOOL MultipleTransactionsSupported = {read=FSupportsMultiTrans, nodefault};
	__property bool ParamsLoaded = {read=FParamsLoaded, write=FParamsLoaded, nodefault};
	__property TISQLConnection* SQLConnection = {read=FISQLConnection, write=FISQLConnection};
	__property bool SQLHourGlass = {read=FSQLHourGlass, write=FSQLHourGlass, default=1};
	__property Dbxpress::TSQLCallbackEvent TraceCallbackEvent = {read=FTraceCallbackEvent};
	__property BOOL TransactionsSupported = {read=FTransactionsSupported, nodefault};
	
__published:
	__property AnsiString ConnectionName = {read=GetConnectionName, write=SetConnectionName};
	__property AnsiString DriverName = {read=FDriverName, write=SetDriverName};
	__property AnsiString GetDriverFunc = {read=FGetDriverFunc, write=FGetDriverFunc};
	__property bool KeepConnection = {read=FKeepConnection, write=SetKeepConnection, default=1};
	__property AnsiString LibraryName = {read=GetLibraryName, write=FLibraryName};
	__property bool LoadParamsOnConnect = {read=FLoadParamsOnConnect, write=FLoadParamsOnConnect, default=0};
	__property LoginPrompt  = {default=1};
	__property Widestrings::TWideStrings* Params = {read=FParams, write=SetParams};
	__property TTableScopes TableScope = {read=FTableScope, write=FTableScope, default=12};
	__property AnsiString VendorLib = {read=GetVendorLib, write=FVendorLib};
	__property AfterConnect ;
	__property AfterDisconnect ;
	__property BeforeConnect ;
	__property BeforeDisconnect ;
	__property TSQLConnectionLoginEvent OnLogin = {read=FOnLogin, write=FOnLogin};
	__property Connected  = {default=0};
};


struct TSQLSchemaInfo
{
	
public:
	TSchemaType FType;
	WideString ObjectName;
	WideString Pattern;
	WideString PackageName;
} ;

typedef void __fastcall (__closure *TParseSqlEvent)(Widestrings::TWideStrings* &FieldNames, WideString SQL, WideString &TableName);

typedef void __fastcall (__closure *TParseInsertSqlEvent)(Widestrings::TWideStrings* &FieldNames, WideString SQL, bool &BindAllFields, WideString &TableName);

class DELPHICLASS TISQLCursor;
class PASCALIMPLEMENTATION TISQLCursor : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	virtual Word __fastcall SetOption(Dbxpress::TSQLCursorOption eOption, int PropValue) = 0 ;
	virtual Word __fastcall SetStringOption(Dbxpress::TSQLCursorOption eOption, const WideString str) = 0 ;
	virtual Word __fastcall GetOption(Dbxpress::TSQLCursorOption eOption, void * PropValue, short MaxLength, /* out */ short &Length) = 0 ;
	virtual Word __fastcall GetStringOption(Dbxpress::TSQLCursorOption eOption, WideString &str) = 0 ;
	virtual WideString __fastcall getCurObjectTypeName(const Word iFldNum) = 0 ;
	virtual Word __fastcall getErrorMessage(WideChar * Error) = 0 /* overload */;
	virtual Word __fastcall getErrorMessageLen(/* out */ short &ErrorLen) = 0 ;
	virtual Word __fastcall getErrorMessage(WideString &Error) = 0 /* overload */;
	virtual Word __fastcall getColumnCount(Word &pColumns) = 0 ;
	virtual Word __fastcall getColumnNameLength(Word ColumnNumber, Word &pLen) = 0 ;
	virtual Word __fastcall getColumnName(Word ColumnNumber, WideChar * pColumnName) = 0 /* overload */;
	virtual WideString __fastcall getColumnName(Word ColumnNumber) = 0 /* overload */;
	virtual Word __fastcall getColumnType(Word ColumnNumber, Word &puType, Word &puSubType) = 0 ;
	virtual Word __fastcall getColumnLength(Word ColumnNumber, unsigned &pLength) = 0 ;
	virtual Word __fastcall getColumnPrecision(Word ColumnNumber, short &piPrecision) = 0 ;
	virtual Word __fastcall getColumnScale(Word ColumnNumber, short &piScale) = 0 ;
	virtual Word __fastcall isNullable(Word ColumnNumber, BOOL &Nullable) = 0 ;
	virtual Word __fastcall isAutoIncrement(Word ColumnNumber, BOOL &AutoIncr) = 0 ;
	virtual Word __fastcall isReadOnly(Word ColumnNumber, BOOL &ReadOnly) = 0 ;
	virtual Word __fastcall isSearchable(Word ColumnNumber, BOOL &Searchable) = 0 ;
	virtual Word __fastcall isBlobSizeExact(Word ColumnNumber, BOOL &IsExact) = 0 ;
	virtual Word __fastcall next(void) = 0 ;
	virtual Word __fastcall getString(Word ColumnNumber, char * Value, BOOL &IsBlank) = 0 ;
	virtual Word __fastcall getWideString(Word ColumnNumber, WideChar * Value, BOOL &IsBlank) = 0 ;
	virtual Word __fastcall getShort(Word ColumnNumber, void * Value, BOOL &IsBlank) = 0 ;
	virtual Word __fastcall getLong(Word ColumnNumber, void * Value, BOOL &IsBlank) = 0 ;
	virtual Word __fastcall getInt64(Word ColumnNumber, void * Value, BOOL &IsBlank) = 0 ;
	virtual Word __fastcall getDouble(Word ColumnNumber, void * Value, BOOL &IsBlank) = 0 ;
	virtual Word __fastcall getBcd(Word ColumnNumber, void * Value, BOOL &IsBlank) = 0 ;
	virtual Word __fastcall getTimeStamp(Word ColumnNumber, void * Value, BOOL &IsBlank) = 0 ;
	virtual Word __fastcall getTime(Word ColumnNumber, void * Value, BOOL &IsBlank) = 0 ;
	virtual Word __fastcall getDate(Word ColumnNumber, void * Value, BOOL &IsBlank) = 0 ;
	virtual Word __fastcall getBytes(Word ColumnNumber, void * Value, BOOL &IsBlank) = 0 ;
	virtual Word __fastcall getBlobSize(Word ColumnNumber, unsigned &Length, BOOL &IsBlank) = 0 ;
	virtual Word __fastcall getBlob(Word ColumnNumber, void * Value, BOOL &IsBlank, unsigned Length) = 0 ;
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TISQLCursor(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TISQLCursor(void) { }
	#pragma option pop
	
};


class DELPHICLASS TFLDDesc;
typedef DynamicArray<TFLDDesc* >  TFieldDescList;

class PASCALIMPLEMENTATION TCustomSQLDataSet : public Db::TWideDataSet 
{
	typedef Db::TWideDataSet inherited;
	
private:
	DynamicArray<Byte >  FBlobBuffer;
	char *FCalcFieldsBuffer;
	bool FCheckRowsAffected;
	TSQLConnection* FClonedConnection;
	WideString FCommandText;
	Db::TPSCommandType FCommandType;
	unsigned FCurrentBlobSize;
	Db::TDataLink* FDataLink;
	AnsiString FDesignerData;
	bool FGetNextRecordSet;
	Db::TIndexDefs* FIndexDefs;
	bool FIndexDefsLoaded;
	AnsiString FLastError;
	int FMaxBlobSize;
	unsigned FMaxColSize;
	WideString FNativeCommand;
	bool FGetMetadata;
	bool FNumericMapping;
	bool FParamCheck;
	int FParamCount;
	Db::TParams* FParams;
	bool FPrepared;
	Classes::TList* FProcParams;
	int FRecords;
	int FRowsAffected;
	TSQLSchemaInfo FSchemaInfo;
	TParseSqlEvent FParseSelectSql;
	TParseSqlEvent FParseUpdateSql;
	TParseSqlEvent FParseDeleteSql;
	TParseInsertSqlEvent FParseInsertSql;
	WideString FSortFieldNames;
	TISQLCommand* FSQLCommand;
	TSQLConnection* FSQLConnection;
	TISQLCursor* FSQLCursor;
	bool FStatementOpen;
	short FTransactionLevel;
	AnsiString FSchemaName;
	bool __fastcall CheckFieldNames(const WideString FieldNames);
	void __fastcall CheckConnection(EConnectFlag eFlag);
	WideString __fastcall CheckDetail(const WideString SQL);
	void __fastcall CheckStatement(bool ForSchema = false);
	bool __fastcall GetCalculatedField(Db::TField* Field, void * &Buffer);
	TCustomSQLDataSet* __fastcall GetDataSetFromSQL(WideString TableName);
	Classes::TList* __fastcall GetProcParams(void);
	TSQLConnection* __fastcall GetInternalConnection(void);
	virtual int __fastcall GetObjectProcParamCount(void);
	virtual int __fastcall GetParamCount(void);
	virtual WideString __fastcall GetQueryFromType();
	int __fastcall GetRowsAffected(void);
	void __fastcall InitBuffers(void);
	void __fastcall LoadFieldDef(Word FieldID, TFLDDesc* &FldDesc)/* overload */;
	void __fastcall ReadDesignerData(Classes::TReader* Reader);
	void __fastcall RefreshParams(void);
	virtual void __fastcall SetConnection(const TSQLConnection* Value);
	void __fastcall SetCurrentBlobSize(unsigned Value);
	void __fastcall SetDataSource(Db::TDataSource* Value);
	void __fastcall SetParameters(const Db::TParams* Value);
	void __fastcall SetParamsFromProcedure(void);
	void __fastcall SetParamsFromSQL(Db::TDataSet* DataSet, bool bFromFields);
	void __fastcall SetPrepared(bool Value);
	virtual void __fastcall SetCommandType(const Db::TSQLCommandType Value);
	void __fastcall WriteDesignerData(Classes::TWriter* Writer);
	void __fastcall SetSchemaName(const AnsiString Value);
	void __fastcall SetSchemaOption(void);
	
protected:
	virtual void __fastcall PSEndTransaction(bool Commit);
	virtual void __fastcall PSExecute(void);
	virtual int __fastcall PSExecuteStatement(const WideString ASQL, Db::TParams* AParams, void * ResultSet = (void *)(0x0))/* overload */;
	virtual void __fastcall PSGetAttributes(Classes::TList* List);
	virtual Db::TIndexDef* __fastcall PSGetDefaultOrder(void);
	virtual WideString __fastcall PSGetKeyFieldsW();
	virtual Db::TIndexDefs* __fastcall PSGetIndexDefs(Db::TIndexOptions IndexTypes);
	virtual Db::TParams* __fastcall PSGetParams(void);
	virtual WideString __fastcall PSGetQuoteCharW();
	virtual WideString __fastcall PSGetTableNameW();
	virtual Db::EUpdateError* __fastcall PSGetUpdateException(Sysutils::Exception* E, Db::EUpdateError* Prev);
	virtual bool __fastcall PSInTransaction(void);
	virtual bool __fastcall PSIsSQLBased(void);
	virtual bool __fastcall PSIsSQLSupported(void);
	virtual void __fastcall PSReset(void);
	virtual void __fastcall PSSetCommandText(const WideString ACommandText)/* overload */;
	virtual void __fastcall PSSetParams(Db::TParams* AParams);
	virtual void __fastcall PSStartTransaction(void);
	virtual bool __fastcall PSUpdateRecord(Db::TUpdateKind UpdateKind, Db::TDataSet* Delta);
	virtual AnsiString __fastcall PSGetCommandText();
	virtual Db::TPSCommandType __fastcall PSGetCommandType(void);
	virtual void __fastcall InternalClose(void);
	virtual void __fastcall InternalHandleException(void);
	virtual void __fastcall InternalInitFieldDefs(void);
	virtual void __fastcall InternalOpen(void);
	virtual bool __fastcall IsCursorOpen(void);
	void __fastcall AddFieldDesc(TFieldDescList FieldDescs, int DescNo, int &FieldID, Classes::TBits* RequiredFields, Db::TFieldDefs* FieldDefs);
	void __fastcall AddIndexDefs(TCustomSQLDataSet* SourceDS, AnsiString IndexName = "");
	Word __fastcall Check(Word status, TSQLExceptionType eType);
	void __fastcall CheckPrepareError(void);
	void __fastcall ClearIndexDefs(void);
	virtual void __fastcall CloseCursor(void);
	void __fastcall CloseStatement(void);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	virtual int __fastcall ExecSQL(bool ExecDirect = false);
	void __fastcall ExecuteStatement(void);
	void __fastcall FreeCursor(void);
	void __fastcall FreeBuffers(void);
	void __fastcall FreeStatement(void);
	virtual bool __fastcall GetCanModify(void);
	virtual Db::TDataSource* __fastcall GetDataSource(void);
	void __fastcall GetObjectTypeNames(Db::TFields* Fields);
	void __fastcall GetOutputParams(Classes::TList* AProcParams = (Classes::TList*)(0x0));
	virtual Db::TGetResult __fastcall GetRecord(char * Buffer, Db::TGetMode GetMode, bool DoCheck);
	WideString __fastcall GetSortFieldNames();
	virtual void __fastcall InitRecord(char * Buffer);
	virtual void __fastcall InternalRefresh(void);
	virtual void __fastcall Loaded(void);
	bool __fastcall LocateRecord(const AnsiString KeyFields, const Variant &KeyValues, Db::TLocateOptions Options, bool SyncCursor);
	virtual void __fastcall OpenCursor(bool InfoQuery);
	virtual void __fastcall OpenSchema(void);
	void __fastcall PropertyChanged(void);
	virtual void __fastcall SetBufListSize(int Value);
	virtual void __fastcall SetCommandText(const WideString Value);
	virtual void __fastcall SetFieldData(Db::TField* Field, void * Buffer)/* overload */;
	void __fastcall SetParamsFromCursor(void);
	void __fastcall SetSortFieldNames(WideString Value);
	void __fastcall SQLError(Word OpStatus, TSQLExceptionType eType);
	virtual void __fastcall UpdateIndexDefs(void);
	__property Db::TBlobByteData BlobBuffer = {read=FBlobBuffer, write=FBlobBuffer};
	__property unsigned CurrentBlobSize = {read=FCurrentBlobSize, write=SetCurrentBlobSize, nodefault};
	__property Db::TDataLink* DataLink = {read=FDataLink};
	__property TSQLConnection* InternalConnection = {read=GetInternalConnection};
	__property AnsiString LastError = {read=FLastError, write=FLastError};
	__property WideString NativeCommand = {read=FNativeCommand, write=FNativeCommand};
	__property Classes::TList* ProcParams = {read=GetProcParams, write=FProcParams};
	__property int RowsAffected = {read=GetRowsAffected, nodefault};
	void __fastcall SetMaxBlobSize(int MaxSize);
	void __fastcall SetFCommandText(const AnsiString Value);
	__property int ParamCount = {read=GetParamCount, nodefault};
	__property TSQLSchemaInfo SchemaInfo = {read=FSchemaInfo, write=FSchemaInfo};
	__property Db::TSQLCommandType CommandType = {read=FCommandType, write=SetCommandType, default=1};
	__property Db::TDataSource* DataSource = {read=GetDataSource, write=SetDataSource};
	__property int MaxBlobSize = {read=FMaxBlobSize, write=SetMaxBlobSize, default=0};
	virtual int __fastcall GetRecordCount(void);
	__property Db::TParams* Params = {read=FParams, write=SetParameters};
	__property bool ParamCheck = {read=FParamCheck, write=FParamCheck, default=1};
	__property WideString SortFieldNames = {read=GetSortFieldNames, write=SetSortFieldNames};
	
public:
	__fastcall virtual TCustomSQLDataSet(Classes::TComponent* AOwner);
	__fastcall virtual ~TCustomSQLDataSet(void);
	__property WideString CommandText = {read=FCommandText, write=SetCommandText};
	virtual Classes::TStream* __fastcall CreateBlobStream(Db::TField* Field, Db::TBlobStreamMode Mode);
	virtual int __fastcall GetBlobFieldData(int FieldNo, Db::TBlobByteData &Buffer);
	virtual void __fastcall GetDetailLinkFields(Classes::TList* MasterFields, Classes::TList* DetailFields);
	virtual bool __fastcall GetFieldData(int FieldNo, void * Buffer)/* overload */;
	virtual bool __fastcall GetFieldData(Db::TField* Field, void * Buffer)/* overload */;
	int __fastcall GetKeyFieldNames(Classes::TStrings* List)/* overload */;
	int __fastcall GetKeyFieldNames(Widestrings::TWideStrings* List)/* overload */;
	virtual WideString __fastcall GetQuoteChar();
	Db::TParam* __fastcall ParamByName(const AnsiString Value);
	virtual void __fastcall PrepareStatement(void);
	__property Db::TIndexDefs* IndexDefs = {read=FIndexDefs, write=FIndexDefs};
	virtual bool __fastcall IsSequenced(void);
	virtual bool __fastcall Locate(const AnsiString KeyFields, const Variant &KeyValues, Db::TLocateOptions Options);
	virtual Variant __fastcall Lookup(const AnsiString KeyFields, const Variant &KeyValues, const AnsiString ResultFields);
	void __fastcall SetSchemaInfo(TSchemaType SchemaType, WideString SchemaObjectName, WideString SchemaPattern, WideString PackageName = L"");
	__property bool Prepared = {read=FPrepared, write=SetPrepared, default=0};
	__property AnsiString DesignerData = {read=FDesignerData, write=FDesignerData};
	__property int RecordCount = {read=GetRecordCount, nodefault};
	__property TSQLConnection* SQLConnection = {read=FSQLConnection, write=SetConnection};
	__property short TransactionLevel = {read=FTransactionLevel, write=FTransactionLevel, default=0};
	
__published:
	__property TParseSqlEvent ParseSelectSql = {read=FParseSelectSql, write=FParseSelectSql};
	__property TParseSqlEvent ParseDeleteSql = {read=FParseDeleteSql, write=FParseDeleteSql};
	__property TParseSqlEvent ParseUpdateSql = {read=FParseUpdateSql, write=FParseUpdateSql};
	__property TParseInsertSqlEvent ParseInsertSql = {read=FParseInsertSql, write=FParseInsertSql};
	__property AnsiString SchemaName = {read=FSchemaName, write=SetSchemaName};
	__property bool GetMetadata = {read=FGetMetadata, write=FGetMetadata, default=1};
	__property bool NumericMapping = {read=FNumericMapping, write=FNumericMapping, default=0};
	__property ObjectView  = {default=0};
	__property BeforeOpen ;
	__property AfterOpen ;
	__property BeforeClose ;
	__property AfterClose ;
	__property BeforeScroll ;
	__property AfterScroll ;
	__property BeforeRefresh ;
	__property AfterRefresh ;
	__property OnCalcFields ;
	__property Active  = {default=0};
	
/* Hoisted overloads: */
	
protected:
	inline int __fastcall  PSExecuteStatement(const AnsiString ASQL, Db::TParams* AParams, void * ResultSet = (void *)(0x0)){ return TWideDataSet::PSExecuteStatement(ASQL, AParams, ResultSet); }
	inline void __fastcall  PSSetCommandText(const AnsiString CommandText){ TWideDataSet::PSSetCommandText(CommandText); }
	inline void __fastcall  SetFieldData(Db::TField* Field, void * Buffer, bool NativeFormat){ TDataSet::SetFieldData(Field, Buffer, NativeFormat); }
	
public:
	inline bool __fastcall  GetFieldData(Db::TField* Field, void * Buffer, bool NativeFormat){ return TDataSet::GetFieldData(Field, Buffer, NativeFormat); }
	
};


class PASCALIMPLEMENTATION TSQLBlobStream : public Classes::TMemoryStream 
{
	typedef Classes::TMemoryStream inherited;
	
private:
	TCustomSQLDataSet* FDataSet;
	Db::TBlobField* FField;
	int FFieldNo;
	
public:
	__fastcall TSQLBlobStream(Db::TBlobField* Field, Db::TBlobStreamMode Mode);
	__fastcall virtual ~TSQLBlobStream(void);
	void __fastcall ReadBlobData(void);
};


#pragma option push -b-
enum TConnectionUserType { eUserMonitor, eUserDataSet };
#pragma option pop

class PASCALIMPLEMENTATION TISQLCommand : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TISQLCursor* FSQLCursor;
	
public:
	__fastcall virtual ~TISQLCommand(void);
	virtual Word __fastcall SetOption(Dbxpress::TSQLCommandOption eSqlCommandOption, int ulValue) = 0 ;
	virtual Word __fastcall SetStringOption(Dbxpress::TSQLCommandOption eSqlCommandOption, const WideString ulValue) = 0 ;
	virtual Word __fastcall GetOption(Dbxpress::TSQLCommandOption eSqlCommandOption, void * PropValue, short MaxLength, /* out */ short &Length) = 0 ;
	virtual Word __fastcall GetStringOption(Dbxpress::TSQLCommandOption eSqlCommandOption, WideString &ulValue) = 0 ;
	virtual Word __fastcall setParameter(Word ulParameter, Word ulChildPos, Dbxpress::TSTMTParamType eParamType, Word uLogType, Word uSubType, int iPrecision, int iScale, unsigned Length, void * pBuffer, int lInd) = 0 ;
	virtual Word __fastcall getParameter(Word ParameterNumber, Word ulChildPos, void * Value, int Length, int &IsBlank) = 0 ;
	virtual Word __fastcall prepare(WideChar * SQL, Word ParamCount) = 0 ;
	virtual Word __fastcall execute(TISQLCursor* &Cursor) = 0 ;
	virtual Word __fastcall executeImmediate(WideChar * SQL, TISQLCursor* &Cursor) = 0 ;
	virtual Word __fastcall getNextCursor(TISQLCursor* &Cursor) = 0 ;
	virtual Word __fastcall getRowsAffected(unsigned &Rows) = 0 ;
	virtual Word __fastcall close(void) = 0 ;
	virtual Word __fastcall getErrorMessage(WideChar * Error) = 0 /* overload */;
	virtual Word __fastcall getErrorMessageLen(/* out */ short &ErrorLen) = 0 ;
	virtual Word __fastcall getErrorMessage(WideString &Error) = 0 /* overload */;
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TISQLCommand(void) : System::TObject() { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TISQLMetaData : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	virtual Word __fastcall SetOption(Dbxpress::TSQLMetaDataOption eDOption, int PropValue) = 0 ;
	virtual Word __fastcall SetStringOption(Dbxpress::TSQLMetaDataOption eDOption, const WideString str) = 0 ;
	virtual Word __fastcall GetOption(Dbxpress::TSQLMetaDataOption eDOption, void * PropValue, short MaxLength, /* out */ short &Length) = 0 ;
	virtual Word __fastcall GetStringOption(Dbxpress::TSQLMetaDataOption eDOption, WideString &str) = 0 ;
	virtual Word __fastcall getObjectList(Dbxpress::TSQLObjectType eObjType, TISQLCursor* &Cursor) = 0 ;
	virtual Word __fastcall getTables(WideChar * TableName, unsigned TableType, TISQLCursor* &Cursor) = 0 ;
	virtual Word __fastcall getProcedures(WideChar * ProcedureName, unsigned ProcType, TISQLCursor* &Cursor) = 0 ;
	virtual Word __fastcall getColumns(WideChar * TableName, WideChar * ColumnName, unsigned ColType, TISQLCursor* &Cursor) = 0 ;
	virtual Word __fastcall getProcedureParams(WideChar * ProcName, WideChar * ParamName, TISQLCursor* &Cursor) = 0 ;
	virtual Word __fastcall getIndices(WideChar * TableName, unsigned IndexType, TISQLCursor* &Cursor) = 0 ;
	virtual Word __fastcall getErrorMessage(WideChar * Error) = 0 /* overload */;
	virtual Word __fastcall getErrorMessageLen(/* out */ short &ErrorLen) = 0 ;
	virtual Word __fastcall getErrorMessage(WideString &Error) = 0 /* overload */;
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TISQLMetaData(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TISQLMetaData(void) { }
	#pragma option pop
	
};


struct SQLTRACEDesc30;
typedef SQLTRACEDesc30 *pSQLTRACEDesc30;

#pragma pack(push,1)
struct SQLTRACEDesc30
{
	
public:
	WideChar pszTrace[1024];
	int eTraceCat;
	int ClientData;
	Word uTotalMsgLen;
} ;
#pragma pack(pop)

struct SQLTRACEDesc25;
typedef SQLTRACEDesc25 *pSQLTRACEDesc25;

#pragma pack(push,1)
struct SQLTRACEDesc25
{
	
public:
	char pszTrace[1024];
	int eTraceCat;
	int ClientData;
	Word uTotalMsgLen;
} ;
#pragma pack(pop)

typedef void __fastcall (__closure *TTraceEvent30)(System::TObject* Sender, pSQLTRACEDesc30 CBInfo, bool &LogTrace);

typedef void __fastcall (__closure *TTraceLogEvent30)(System::TObject* Sender, pSQLTRACEDesc30 CBInfo);

typedef void __fastcall (__closure *TTraceEvent25)(System::TObject* Sender, pSQLTRACEDesc25 CBInfo, bool &LogTrace);

typedef void __fastcall (__closure *TTraceLogEvent25)(System::TObject* Sender, pSQLTRACEDesc25 CBInfo);

typedef SQLTRACEDesc30 *pSQLTRACEDesc;

typedef SQLTRACEDesc30  SQLTRACEDesc;

typedef void __fastcall (__closure *TTraceEvent)(System::TObject* Sender, pSQLTRACEDesc30 CBInfo, bool &LogTrace);

typedef void __fastcall (__closure *TTraceLogEvent)(System::TObject* Sender, pSQLTRACEDesc30 CBInfo);

class DELPHICLASS TSQLMonitor;
class PASCALIMPLEMENTATION TSQLMonitor : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	bool FActive;
	bool FAutoSave;
	AnsiString FFileName;
	bool FKeepConnection;
	int FMaxTraceCount;
	TTraceEvent30 FOnTrace;
	TTraceLogEvent30 FOnLogTrace;
	TSQLConnection* FSQLConnection;
	bool FStreamedActive;
	Dbxpress::TSQLTraceFlags FTraceFlags;
	Widestrings::TWideStrings* FTraceList;
	void __fastcall CheckInactive(void);
	int __fastcall GetTraceCount(void);
	
protected:
	Dbcommontypes::CBRType __stdcall InvokeCallBack(int CallType, void * CBInfo);
	void __fastcall SetActive(bool Value);
	void __fastcall SetSQLConnection(TSQLConnection* Value);
	void __fastcall SetStreamedActive(void);
	void __fastcall SetTraceList(Widestrings::TWideStrings* Value);
	void __fastcall SetFileName(const AnsiString Value);
	void __fastcall SwitchConnection(const TSQLConnection* Value);
	virtual void __fastcall Trace(pSQLTRACEDesc30 Desc, bool LogTrace);
	void __fastcall UpdateTraceCallBack(void);
	
public:
	__fastcall virtual TSQLMonitor(Classes::TComponent* AOwner);
	__fastcall virtual ~TSQLMonitor(void);
	void __fastcall LoadFromFile(AnsiString AFileName);
	void __fastcall SaveToFile(AnsiString AFileName);
	__property int MaxTraceCount = {read=FMaxTraceCount, write=FMaxTraceCount, nodefault};
	__property int TraceCount = {read=GetTraceCount, nodefault};
	
__published:
	__property bool Active = {read=FActive, write=SetActive, default=0};
	__property bool AutoSave = {read=FAutoSave, write=FAutoSave, default=0};
	__property AnsiString FileName = {read=FFileName, write=SetFileName};
	__property TTraceLogEvent30 OnLogTrace = {read=FOnLogTrace, write=FOnLogTrace};
	__property TTraceEvent30 OnTrace = {read=FOnTrace, write=FOnTrace};
	__property Widestrings::TWideStrings* TraceList = {read=FTraceList, write=SetTraceList, stored=false};
	__property TSQLConnection* SQLConnection = {read=FSQLConnection, write=SetSQLConnection};
};


typedef void *TLocale;

typedef void __fastcall (__closure *TConnectChangeEvent)(System::TObject* Sender, bool Connecting);

class DELPHICLASS TSQLDataLink;
class PASCALIMPLEMENTATION TSQLDataLink : public Db::TDetailDataLink 
{
	typedef Db::TDetailDataLink inherited;
	
private:
	TCustomSQLDataSet* FSQLDataSet;
	
protected:
	virtual void __fastcall ActiveChanged(void);
	virtual void __fastcall CheckBrowseMode(void);
	virtual Db::TDataSet* __fastcall GetDetailDataSet(void);
	virtual void __fastcall RecordChanged(Db::TField* Field);
	
public:
	__fastcall TSQLDataLink(TCustomSQLDataSet* ADataSet);
public:
	#pragma option push -w-inl
	/* TDataLink.Destroy */ inline __fastcall virtual ~TSQLDataLink(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TFLDDesc : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	virtual Word __fastcall GetiFldNum(void) = 0 ;
	virtual WideString __fastcall GetszName(void) = 0 ;
	virtual Word __fastcall GetiFldType(void) = 0 ;
	virtual Word __fastcall GetiSubType(void) = 0 ;
	virtual short __fastcall GetiUnits1(void) = 0 ;
	virtual short __fastcall GetiUnits2(void) = 0 ;
	virtual Word __fastcall GetiOffset(void) = 0 ;
	virtual unsigned __fastcall GetiLen(void) = 0 ;
	virtual Word __fastcall GetiNullOffset(void) = 0 ;
	virtual Dbcommontypes::FLDVchk __fastcall GetefldvVchk(void) = 0 ;
	virtual Dbcommontypes::FLDRights __fastcall GetefldrRights(void) = 0 ;
	virtual Word __fastcall GetbCalcField(void) = 0 ;
	virtual void __fastcall SetiFldNum(Word Value) = 0 ;
	virtual void __fastcall SetszName(WideString Value) = 0 ;
	virtual void __fastcall SetiFldType(Word Value) = 0 ;
	virtual void __fastcall SetiSubType(Word Value) = 0 ;
	virtual void __fastcall SetiUnits1(short Value) = 0 ;
	virtual void __fastcall SetiUnits2(short Value) = 0 ;
	virtual void __fastcall SetiOffset(Word Value) = 0 ;
	virtual void __fastcall SetiLen(unsigned Value) = 0 ;
	virtual void __fastcall SetiNullOffset(Word Value) = 0 ;
	virtual void __fastcall SetefldvVchk(Dbcommontypes::FLDVchk Value) = 0 ;
	virtual void __fastcall SetefldrRights(Dbcommontypes::FLDRights Value) = 0 ;
	virtual void __fastcall SetbCalcField(Word Value) = 0 ;
	
public:
	__property Word iFldNum = {read=GetiFldNum, write=SetiFldNum, nodefault};
	__property WideString szName = {read=GetszName, write=SetszName};
	__property Word iFldType = {read=GetiFldType, write=SetiFldType, nodefault};
	__property Word iSubType = {read=GetiSubType, write=SetiSubType, nodefault};
	__property short iUnits1 = {read=GetiUnits1, write=SetiUnits1, nodefault};
	__property short iUnits2 = {read=GetiUnits2, write=SetiUnits2, nodefault};
	__property Word iOffset = {read=GetiOffset, write=SetiOffset, nodefault};
	__property unsigned iLen = {read=GetiLen, write=SetiLen, nodefault};
	__property Word iNullOffset = {read=GetiNullOffset, write=SetiNullOffset, nodefault};
	__property Dbcommontypes::FLDVchk efldvVchk = {read=GetefldvVchk, write=SetefldvVchk, nodefault};
	__property Dbcommontypes::FLDRights efldrRights = {read=GetefldrRights, write=SetefldrRights, nodefault};
	__property Word bCalcField = {read=GetbCalcField, write=SetbCalcField, nodefault};
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TFLDDesc(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TFLDDesc(void) { }
	#pragma option pop
	
};


class DELPHICLASS TSQLDataSet;
class PASCALIMPLEMENTATION TSQLDataSet : public TCustomSQLDataSet 
{
	typedef TCustomSQLDataSet inherited;
	
public:
	__fastcall virtual TSQLDataSet(Classes::TComponent* AOwner);
	virtual int __fastcall ExecSQL(bool ExecDirect = false);
	
__published:
	__property CommandText ;
	__property CommandType  = {default=1};
	__property DataSource ;
	__property MaxBlobSize  = {default=0};
	__property ParamCheck  = {default=1};
	__property Params ;
	__property SortFieldNames ;
	__property SQLConnection ;
public:
	#pragma option push -w-inl
	/* TCustomSQLDataSet.Destroy */ inline __fastcall virtual ~TSQLDataSet(void) { }
	#pragma option pop
	
};


class DELPHICLASS TSQLQuery;
class PASCALIMPLEMENTATION TSQLQuery : public TCustomSQLDataSet 
{
	typedef TCustomSQLDataSet inherited;
	
private:
	Widestrings::TWideStrings* FSQL;
	AnsiString FText;
	void __fastcall QueryChanged(System::TObject* Sender);
	void __fastcall SetSQL(Widestrings::TWideStrings* Value);
	
public:
	__fastcall virtual TSQLQuery(Classes::TComponent* AOwner);
	__fastcall virtual ~TSQLQuery(void);
	virtual int __fastcall ExecSQL(bool ExecDirect = false);
	virtual void __fastcall PrepareStatement(void);
	__property RowsAffected ;
	__property AnsiString Text = {read=FText};
	
__published:
	__property DataSource ;
	__property GetMetadata  = {default=0};
	__property MaxBlobSize  = {default=0};
	__property ParamCheck  = {default=1};
	__property Params ;
	__property Widestrings::TWideStrings* SQL = {read=FSQL, write=SetSQL};
	__property SQLConnection ;
};


class DELPHICLASS TSQLStoredProc;
class PASCALIMPLEMENTATION TSQLStoredProc : public TCustomSQLDataSet 
{
	typedef TCustomSQLDataSet inherited;
	
private:
	WideString FStoredProcName;
	WideString FPackageName;
	void __fastcall SetStoredProcName(WideString Value);
	void __fastcall SetPackageName(WideString Value);
	
public:
	__fastcall virtual TSQLStoredProc(Classes::TComponent* AOwner);
	virtual int __fastcall ExecProc(void);
	TCustomSQLDataSet* __fastcall NextRecordSet(void);
	virtual void __fastcall PrepareStatement(void);
	
__published:
	__property MaxBlobSize  = {default=0};
	__property ParamCheck  = {default=1};
	__property Params ;
	__property WideString PackageName = {read=FPackageName, write=SetPackageName};
	__property SQLConnection ;
	__property WideString StoredProcName = {read=FStoredProcName, write=SetStoredProcName};
public:
	#pragma option push -w-inl
	/* TCustomSQLDataSet.Destroy */ inline __fastcall virtual ~TSQLStoredProc(void) { }
	#pragma option pop
	
};


class DELPHICLASS TSQLTable;
class PASCALIMPLEMENTATION TSQLTable : public TCustomSQLDataSet 
{
	typedef TCustomSQLDataSet inherited;
	
private:
	bool FIsDetail;
	Classes::TList* FIndexFields;
	WideString FIndexFieldNames;
	WideString FIndexName;
	Db::TMasterDataLink* FMasterLink;
	WideString FTableName;
	int FIndexFieldCount;
	void __fastcall AddParamsToQuery(void);
	WideString __fastcall GetMasterFields();
	Db::TField* __fastcall GetIndexField(int Index);
	int __fastcall GetIndexFieldCount(void);
	int __fastcall RefreshIndexFields(void);
	void __fastcall SetIndexFieldNames(WideString Value);
	void __fastcall SetIndexName(WideString Value);
	void __fastcall SetMasterFields(WideString Value);
	void __fastcall SetTableName(WideString Value);
	virtual WideString __fastcall GetQueryFromType();
	HIDESBASE void __fastcall SetDataSource(Db::TDataSource* Value);
	
protected:
	virtual void __fastcall OpenCursor(bool InfoQuery);
	void __fastcall SetIndexField(int Index, Db::TField* Value);
	__property Db::TMasterDataLink* MasterLink = {read=FMasterLink};
	
public:
	__fastcall virtual TSQLTable(Classes::TComponent* AOwner);
	__fastcall virtual ~TSQLTable(void);
	void __fastcall DeleteRecords(void);
	void __fastcall GetIndexNames(Widestrings::TWideStrings* List);
	virtual void __fastcall PrepareStatement(void);
	__property Db::TField* IndexFields[int Index] = {read=GetIndexField, write=SetIndexField};
	__property int IndexFieldCount = {read=GetIndexFieldCount, nodefault};
	
__published:
	__property Active  = {default=0};
	__property WideString IndexFieldNames = {read=FIndexFieldNames, write=SetIndexFieldNames};
	__property WideString IndexName = {read=FIndexName, write=SetIndexName};
	__property WideString MasterFields = {read=GetMasterFields, write=SetMasterFields};
	__property Db::TDataSource* MasterSource = {read=GetDataSource, write=SetDataSource};
	__property MaxBlobSize  = {default=0};
	__property SQLConnection ;
	__property WideString TableName = {read=FTableName, write=SetTableName};
};


typedef Word __stdcall (*TGetDriverFunc)(char * SVendorLib, char * SResourceFile, /* out */ void *Obj);

//-- var, const, procedure ---------------------------------------------------
#define SSelect "select"
#define SSelectStar " select * "
#define SSelectStarFrom " select * from "
#define SSelectSpaces " select "
#define SWhere " where "
#define SAnd " and "
#define SOrderBy " order by "
static const char SParam = '\x3f';
static const Shortint DefaultCursor = 0x0;
static const Shortint HourGlassCursor = -11;
static const Shortint DefaultMaxBlobSize = -1;
static const Shortint DefaultRowsetSize = 0x14;
static const Word TErrorMessageSize = 0x800;
extern PACKAGE Byte FldTypeMap[42];
extern PACKAGE Word FldSubTypeMap[42];
extern PACKAGE Db::TFieldType DataTypeMap[27];
extern PACKAGE Db::TFieldType BlobTypeMap[15];
extern PACKAGE HRESULT __stdcall (*DllGetClassObject)(const GUID &CLSID, const GUID &IID, void *Obj);
extern DELPHITHREAD TGetDriverFunc GetDriver;
extern DELPHITHREAD unsigned DllHandle;
extern PACKAGE AnsiString __fastcall GetDriverRegistryFile(bool DesignMode = false);
extern PACKAGE AnsiString __fastcall GetConnectionRegistryFile(bool DesignMode = false);
extern PACKAGE void __fastcall GetDriverNames(Classes::TStrings* List, bool DesignMode = true);
extern PACKAGE void __fastcall GetConnectionNames(Classes::TStrings* List, AnsiString Driver = "", bool DesignMode = true);
extern PACKAGE void __fastcall FreeProcParams(Classes::TList* &ProcParams);
extern PACKAGE void __fastcall LoadParamListItems(Db::TParams* Params, Classes::TList* ProcParams);
extern PACKAGE void __fastcall RegisterDbXpressLib(void * GetClassProc);

}	/* namespace Sqlexpr */
using namespace Sqlexpr;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Sqlexpr
